//
//  RaysOfGod.fsh
//  Untitled
//
//  Created by dutty on 10.10.10.
//  Copyright 2010 drahtwerk. All rights reserved.
//

#ifdef OGL_ES2
#	ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#	else
precision mediump float;
#	endif
#	define prec_high highp
#	define prec_med mediump
#	define prec_low lowp
#else 
#	define prec_high
#	define prec_med 
#	define prec_low 
#endif


varying prec_med vec2 v_texture0_coord;

uniform prec_med vec2 u_textureSpace_lightPosition;
uniform prec_med sampler2D u_texture;

uniform prec_high float u_exposure;		/**< general brightness of light. */
uniform prec_high float u_density;		/**< density how long occluders block light, bigger value longer tail. */
uniform prec_high float u_weight;		/**< initial light ray brightness. */
uniform prec_high float u_decay;		/**< light fall of from origin. each iteration the light weight is multiplied with this value */

uniform prec_low int u_sampleCount;		

void main()
{	
	// Keep the number as big as possible - no need to scale down by NumSamples yet.
    prec_med vec2 v2Delta = v_texture0_coord - u_textureSpace_lightPosition;
    prec_low vec3 v3Color = vec3(0.0);
 	prec_med float illuminationDecay = u_weight;
    prec_med float densityFalloff = u_density / float(u_sampleCount);

    for(int i = 1; i <= u_sampleCount; i++)
    {
        prec_high vec2 v2TexCoord = v2Delta * float(-i) * densityFalloff; // Multiply by iteration rather than accumulating.
        v2TexCoord += v_texture0_coord; // Then add to the larger number, precision loss may also occur here.
        
		prec_low vec3 v3Texel = texture2D(u_texture, v2TexCoord).rgb;
        v3Color += v3Texel * illuminationDecay;

		// control light decay
	 	illuminationDecay *= u_decay;
    }

    gl_FragColor = vec4(v3Color.rgb * u_exposure, 1.0);
}




